/**
 * 帖子相关的 缓存
 */
import {
  type IOfficialTagList,
  type IPostType,
  type IShieldType,
  getColleagueTagList,
  getPostType,
  getShieldTypeList,
} from '@/api'
import { localCache } from '@/utils/storage'
import { defineStore } from 'pinia'

interface ICachePostTime {
  [id: string]: number
}
export const usePostStore = defineStore({
  id: 'post',
  state: () => {
    return {
      // 缓存上一次查看帖子的时间
      cachePostTime: {} as { [id: string]: number },

      // 分类数据
      typeData: [] as IPostType[],
      // 已屏蔽的分类
      shieldTypeData: [] as IShieldType[],

      // 官方标签
      tagData: [] as IOfficialTagList[],
    }
  },
  actions: {
    /**
     * 页面滚动位置
     */
    setPostTime(id: string, number: number) {
      this.cachePostTime[id] = number
      localCache.setCache('post_time', this.cachePostTime, 1000 * 60 * 60 * 48)
    },
    getPostTime(id: string) {
      if (this.cachePostTime[id]) {
        return this.cachePostTime[id]
      }
      const time = localCache.getCache<ICachePostTime>('post_time')
      if (time) {
        return time[id]
      }
      return undefined
    },

    /**
     * 分类获取
     */
    async queryPostType() {
      if (this.typeData.length > 0) {
        return this.typeData
      }
      const res = await getPostType()
      this.typeData = res.data
      return this.typeData
    },
    /**
     * 获取屏蔽帖子分类列表
     * @param isFresh 是否强制刷新
     */
    async queryShieType(isFresh = false) {
      if (!isFresh && this.shieldTypeData.length > 0) {
        return this.shieldTypeData
      }
      const res = await getShieldTypeList()
      this.shieldTypeData = res.data
      return this.shieldTypeData
    },

    /**
     * 标签获取
     */
    async queryOfficialTag() {
      if (this.tagData.length > 0) {
        return this.tagData
      }
      const res = await getColleagueTagList()
      this.tagData = res.data
      return this.tagData
    },
  },
})
