import service from '@/utils/request/index'
import type {
  AddOrUpdateArticleDto,
  ArticleItemDto,
  ArticleSearchParams,
  InterviewItemDto,
  ColumnItemDto,
} from './types'
import type { BackendServicePageResult } from '@/utils/request/types'
import { ArticleTypeEnum } from '@/constants'

// 文章相关的接口(帖子 视频 实践等)

/**
 * 发布文章 暂时由 有帖子 专栏 专访
 */
export const addOrUpdateArticle = (data: AddOrUpdateArticleDto) => {
  return service.request<boolean>({
    url: '/api/cultureArticle/addOrUpdateArticle',
    method: 'POST',
    data,
  })
}

/**
 * 文章列表
 */
export const getArticleList = (data: ArticleSearchParams) => {
  return service.request<BackendServicePageResult<ArticleItemDto>>({
    url: '/api/cultureArticle/listByPage',
    method: 'POST',
    data,
  })
}

/**
 * 文章详情
 */
export const getArticleDetail = (articleId: number | string) => {
  return service.request<ArticleItemDto>({
    url: `/api/cultureArticle/getArticleDetail?articleId=${articleId}`,
    method: 'POST',
  })
}

/**
 * 收藏或者取消收藏
 */
export const addOrCancelCollect = (data: { articleId: number | string; type: ArticleTypeEnum }) => {
  return service.request<boolean>({
    url: `/api/cultureCollect/addOrCancelCollect`,
    method: 'POST',
    data,
  })
}

/**
 * 获取专访列表--不分页
 */
export const getInterviewList = () => {
  return service.request<InterviewItemDto[]>({
    url: '/api/cultureColumn/listNoPage?type=interview',
    method: 'POST',
  })
}

/**
 * 获取专栏列表-- 不分页
 */
export const getColumnList = () => {
  return service.request<ColumnItemDto[]>({
    url: '/api/cultureColumn/listNoPage?type=column',
    method: 'POST',
  })
}
