import { ArticleTypeEnum, ReleaseStatusTypeEnum, BooleanFlag, SendTypeEnum } from '@/constants'
import type { PageSearchParams } from '@/utils/request/types'

/**
 * 搜索文章的参数
 */
export interface ArticleSearchParams extends PageSearchParams {
  type?: ArticleTypeEnum
}

/**
 * 添加或更新文章DTO（带枚举版本）
 */
export type AddOrUpdateArticleDto =
  | AddOrUpdatePostDto
  | AddOrUpdateColumnDto
  | AddOrUpdateInterviewDto

/**
 * 添加帖子的DTO
 */
export interface AddOrUpdatePostDto {
  id?: number
  title: string
  content: string
  releaseStatus: ReleaseStatusTypeEnum
  sendType: SendTypeEnum
  faceUrl?: string
  imgUrl?: string
  sendTime?: string
  type: ArticleTypeEnum.POST
}

interface AddOrUpdateColumnBase {
  id?: number
  type: ArticleTypeEnum.COLUMN
  title: string
  content: string
  releaseStatus: ReleaseStatusTypeEnum
  sendType: SendTypeEnum
  faceUrl?: string
  imgUrl?: string
  // 关联的专栏栏目
  relateColumn: number
  mainTagId: string
  isRelateColleague: BooleanFlag
  sendTime?: string
}

/**
 * 添加专栏的原始form类型
 */
export interface AddOrUpdateColumnForm extends AddOrUpdateColumnBase {
  tagList: number[]
}

/**
 * 添加专栏的DTO
 */
export interface AddOrUpdateColumnDto extends AddOrUpdateColumnBase {
  tagList: { tagId: number; sort: number }[]
}

export interface AddOrUpdateInterviewBase {
  id?: number
  type: ArticleTypeEnum.INTERVIEW
  title: string
  content: string
  releaseStatus: ReleaseStatusTypeEnum
  sendType: SendTypeEnum
  faceUrl?: string
  imgUrl?: string
  // 关联的专访栏目
  relateColumn: number
  mainTagId: string
  sendTime?: string
}

export interface AddOrUpdateInterviewForm extends AddOrUpdateInterviewBase {
  tagList: number[]
}

/**
 * 添加专访的DTO
 */
export interface AddOrUpdateInterviewDto extends AddOrUpdateInterviewBase {
  tagList: { tagId: number; sort: number }[]
}

/**
 * 添加专访的DTO
 */

/**
 *  文章详情
 */

// 更严格的类型定义
export interface ArticleItemDto {
  id: number
  title: string
  content: string
  faceUrl: string
  videoUrl: string
  description: string
  createUserId: number
  createTime: number
  viewCount: number
  isRecommend: BooleanFlag
  type: ArticleTypeEnum
  isRelateColleague: BooleanFlag
  releaseStatus: ReleaseStatusTypeEnum
  tagNameList: string[]
  praiseCount: number
  collectionCount: number
  replyCount: number
  hasPraised: BooleanFlag
}

export interface ColumnItemDto {
  color: string
  createTime: number
  createUserId: number
  id: number
  isDelete: BooleanFlag
  sort: number
  status: BooleanFlag
  title: string
  type: 'column'
}

export interface InterviewItemDto {
  color: string
  createTime: number
  createUserId: number
  id: number
  isDelete: BooleanFlag
  sort: number
  status: BooleanFlag
  title: string
  type: 'column'
}
