import type { PageSearchParams } from '@/utils/request/types'
import { BooleanFlag, ShopGoodsTypeEnum } from '@/constants'

/**
 * 商品列表搜索参数
 */
export interface ShopSearchParams extends PageSearchParams {
  region: string
  itemType: ShopGoodsTypeEnum
}

/**
 * 积分商城商品类型
 */
export interface ShopItemDto {
  id: number
  description: string
  enable: number
  imageUrl: string
  itemType: number
  itemTypeName: string
  name: string
  price: number
  region: string
  soldOut: boolean
  sotrOrder: number
  stock: number
}

/**
 * 商品领取列表搜索参数
 */
export interface ExchangeGoodsRecordSearchParams extends PageSearchParams {
  receiveTimeStart: number
  receiveTimeEnd: number
  itemType: ShopGoodsTypeEnum
}

/**
 * yabi信息对象类型
 */
export interface YaBiData {
  currentValue: number
}

/**
 * 兑换商品请求参数类型
 */
export interface ExchangeGoodsParams {
  itemId: number
  num: number
  deliveryInfo?: string
}

/**
 * 商品领取列表item Dto
 */
export interface ExchangeGoodsRecordItemDto {
  createTime: number
  deliveryInfo: string
  id: number
  isDelete: BooleanFlag
  itemId: number
  itemName: string
  itemType: ShopGoodsTypeEnum
  num: number
  price: number
  status: number
  userId: number
}

/**
 * 获取用户YA币收支记录
 */
export interface ExchangeYabiRecordItemDto {
  actionType: string
  actionTypeText: string
  createdAt: number
  createdTimeText: string
  currentValue: number
  id: number
  incrText: string
  isDelete: BooleanFlag
  isIncr: BooleanFlag
  isSign: BooleanFlag
  relationId: number
  remark: string
  scoreAyabi: number
  scoreExp: number
  subType: string
  userId: number
}
