import { defineStore } from 'pinia'
import { getInterviewList } from '@/api'
import type { InterviewItemDto } from '@/api/article/types'
/**
 * 关于专访的相关数据 --不分页
 */
export const useInterviewStore = defineStore('interview', () => {
  const interviewList = ref<InterviewItemDto[]>([])

  let isLoading = false

  const fetchInterviewList = async () => {
    if (isLoading) return
    if (interviewList.value.length > 0) return
    isLoading = true
    try {
      const { data } = await getInterviewList()
      interviewList.value = data
      console.log(interviewList.value, 'interviewList')
    } catch (error) {
      console.error(error)
    } finally {
      isLoading = false
    }
  }
  fetchInterviewList()

  return { interviewList, fetchInterviewList }
})
