import { ArticleTypeEnum, AuditStatusEnum, CommentTypeEnum, TaskTypeEnum } from './enums'

// 地区列表
export const regionListOptions = [
  {
    label: '深圳',
    value: '深圳',
  },
  {
    label: '合肥',
    value: '合肥',
  },
  {
    label: '武汉',
    value: '武汉',
  },
  {
    label: '长沙',
    value: '长沙',
  },
  {
    label: '广州',
    value: '广州',
  },
  {
    label: '香港',
    value: '香港',
  },
  {
    label: '仓库',
    value: '仓库',
  },
]

// 文章类型列表
export const articleTypeListOptions: { label: string; value: ArticleTypeEnum }[] = [
  {
    label: '帖子',
    value: ArticleTypeEnum.POST,
  },
  {
    label: '视频',
    value: ArticleTypeEnum.VIDEO,
  },
  {
    label: '问题',
    value: ArticleTypeEnum.QUESTION,
  },
  {
    label: '专栏',
    value: ArticleTypeEnum.COLUMN,
  },
  {
    label: '实践',
    value: ArticleTypeEnum.PRACTICE,
  },
  {
    label: '专访',
    value: ArticleTypeEnum.INTERVIEW,
  },
]

// 审核类型列表
export const auditTypeListOptions: { label: string; value: AuditStatusEnum }[] = [
  {
    label: '待审核',
    value: AuditStatusEnum.UNAUDITED,
  },
  {
    label: '同意',
    value: AuditStatusEnum.AGREED,
  },
  {
    label: '拒绝',
    value: AuditStatusEnum.REJECTED,
  },
]

// 任务类型列表
export const taskTypeListOptions = [
  {
    label: '常规任务',
    value: TaskTypeEnum.REGULAR_TASK,
  },
  {
    label: '特殊任务',
    value: TaskTypeEnum.SPECIAL_TASK,
  },
]

// 评论类型列表
export const commentTypeListOptions = [
  {
    label: '我评论的',
    value: CommentTypeEnum.COMMNET_TO_OTHER,
  },
  {
    label: '评论我的',
    value: CommentTypeEnum.COMMNET_TO_SELF,
  },
]

// 等级相关内容
export const levelListOptions: {
  label: string
  value: number
  iconUrl: string
  expScope: [number, number]
}[] = [
  {
    label: 'LV1',
    value: 1,
    iconUrl:
      'https://soundasia.oss-cn-shenzhen.aliyuncs.com/OA/readName/png/2025/11/17/Common/1763370983822.png',
    expScope: [0, 500],
  },

  {
    label: 'LV2',
    value: 2,
    iconUrl:
      'https://soundasia.oss-cn-shenzhen.aliyuncs.com/OA/readName/png/2025/11/17/Common/1763370990111.png',
    expScope: [500, 1500],
  },
  {
    label: 'LV3',
    value: 3,
    iconUrl:
      'https://soundasia.oss-cn-shenzhen.aliyuncs.com/OA/readName/png/2025/11/17/Common/1763370993043.png',
    expScope: [1500, 3000],
  },
  {
    label: 'LV4',
    value: 4,
    iconUrl:
      'https://soundasia.oss-cn-shenzhen.aliyuncs.com/OA/readName/png/2025/11/17/Common/1763370996142.png',
    expScope: [3000, 6000],
  },
  {
    label: 'LV5',
    value: 5,
    iconUrl:
      'https://soundasia.oss-cn-shenzhen.aliyuncs.com/OA/readName/png/2025/11/17/Common/1763370998414.png',
    expScope: [6000, 12000],
  },
]
