/**
 * 添加或更新案例库DTO
 */
import {
  TagTypeEnum,
  TagLevelEnum,
  BooleanFlag,
  ReleaseStatusTypeEnum,
  AuditStatusEnum,
} from '@/constants'

type TagItemDto = {
  tagId: number
  type: TagTypeEnum
  keywordType: TagLevelEnum
}

export interface AddOrUpdateCaseDto {
  content: string
  deptId: string
  deptName: string
  isSync: BooleanFlag
  releaseStatus: ReleaseStatusTypeEnum
  sourceUser: string
  tagRelationDtoList: TagItemDto[]
  title: string
}
export interface CaseDetailDto {
  id: number
  title: string
  content: string
  caseTags: TagItemDto[]
  depIdList: number[]
  depNameList: string[]
  isSync: BooleanFlag
  cultureKeywordMain: string
  cultureKeywordSub: string[]
  sceneKeywordMain: string
  sceneKeywordSub: string[]
  isAudit: AuditStatusEnum
}
