import type { SetupContext } from 'vue'

type TypeOfValue = string | number
type TabsProps = {
  tabs: {
    label: string
    value: TypeOfValue
  }[]
  modelValue: TypeOfValue
}

type TabsEmits = {
  'update:modelValue': [TypeOfValue]
  change: [TypeOfValue]
  setA: [string]
}

const BASE_TAB_CALASSES =
  'tab-item cursor-pointer bg-white rounded-lg flex items-center justify-center px-4 py-2 min-w-20 h-8 transition-all duration-300 hover:shadow-md hover:bg-#D9EFFD/20 hover:text-#000/80 hover:-translate-y-0.5 active:scale-95 font-medium text-14px text-#000/55 shadow-sm'
const ACTIVE_TAB_CLASSES = ' !bg-#D9EFFD shadow-lg transform -translate-y-1 !text-#000'
//       <div class="left flex gap-3"> 未设置排列方式 需要给父组件设置 flex布局
export default function Tabs({ tabs, modelValue }: TabsProps, { emit }: SetupContext<TabsEmits>) {
  return tabs.map((tab) => (
    <div
      key={tab.value}
      class={[
        BASE_TAB_CALASSES,
        {
          [ACTIVE_TAB_CLASSES]: modelValue === tab.value,
        },
      ]}
      onClick={() => {
        emit('update:modelValue', tab.value)
        emit('change', tab.value)
      }}
    >
      {tab.label}
    </div>
  ))
}
