import { fileURLToPath, URL } from 'node:url'
import { defineConfig } from 'vite'
import vue from '@vitejs/plugin-vue'
import vueJsx from '@vitejs/plugin-vue-jsx'
import vueDevTools from 'vite-plugin-vue-devtools'
import AutoImport from 'unplugin-auto-import/vite'
import Components from 'unplugin-vue-components/vite'
import { ElementPlusResolver } from 'unplugin-vue-components/resolvers'
import { createSvgIconsPlugin } from 'vite-plugin-svg-icons'
import UnoCSS from 'unocss/vite'

import path from 'node:path'

// https://vite.dev/config/
export default defineConfig({
  resolve: {
    //设置别名
    alias: {
      '@': fileURLToPath(new URL('./src', import.meta.url)),
    },
  },
  plugins: [
    vue(),
    vueJsx(),
    vueDevTools(),
    AutoImport({
      imports: ['vue', 'vue-router'],
      resolvers: [ElementPlusResolver()],
      dts: true,
      eslintrc: {
        enabled: true, // 生成 eslint 配置
      },
    }),
    Components({
      resolvers: [ElementPlusResolver()],
      include: ['src/**/*.vue', 'src/**/*.tsx'],
      dts: true,
    }),
    UnoCSS(),
    createSvgIconsPlugin({
      // 指定需要缓存的图标文件夹(路径为存放所有svg图标的文件夹不单个svg图标)
      iconDirs: [path.resolve(process.cwd(), 'src/assets/svg')],
      // 指定symbolId格式
      symbolId: 'icon-[dir]-[name]',
    }),
  ],
  server: {
    // 是否开启 https
    // https: false as const,
    proxy: {
      '/api1': {
        target: 'http://192.168.2.168:8089', // 首拥本地
        changeOrigin: true,
        rewrite: (path) => {
          return path.replace(/^\/api1/, '')
        },
      },
    },
  },
})
