import type { PageSearchParams } from '@/utils/request/types'
import { BooleanFlag, ShopGoodsTypeEnum } from '@/constants'
export interface BackendShopListSearchParams extends PageSearchParams {
  name?: string
  itemType?: ShopGoodsTypeEnum
  region?: string
  enable?: 0 | 1
}
export interface BackendShopItemDto {
  id?: number
  sort: number
  enable: BooleanFlag
  imageUrl: string
  itemType: ShopGoodsTypeEnum
  name: string
  price: number
  region: string
  title: string
  description: string
  imgUrl: string
  stock: number
  status: number
}

export interface AddOrUpdateShopItemDto {
  id?: number
  title: string
  description: string
  imgUrl: string
  price: number
  stock: number
  status: number
}
export interface BackendExchangeListSearchParams extends PageSearchParams {
  source: string
  status?: 0 | 1 | 2
  itemName?: string
}
