import { ArticleTypeEnum } from '@/constants'
import type { PageSearchParams } from '@/utils/request/types'
export interface ArticleSearchParams extends PageSearchParams {
  title?: string
  type?: ArticleTypeEnum
}

export interface AddOrUpdateCarouselDto {
  articleTitle: string
  assetUrl: string
  id?: number
  isRelease: number
  sort: number
  type: number
  url: string
}
export interface BackendCarouselListItemDto {
  articleId: number
  articleTitle: string
  assetUrl: string
  id: number
  isRelease: number
  lastName: string
  lastTime: number
  sort: number
  type: number
  url: string
}
export interface BackendArticleListItemDto {
  collectionCount: number
  content: string
  createTime: number
  createUserId: number
  description: string
  faceUrl: string
  hasAddQuestion: boolean
  hasCollect: boolean
  hasPraised: boolean
  id: number
  isRecommend: number
  isRelateColleague: number
  praiseCount: number
  releaseStatus: number
  replyCount: number
  showAvatar: string
  showName: string
  tagNameList: string[]
  title: string
  type: ArticleTypeEnum
  videoDuration: string
  videoUrl: string
  viewCount: number
}
