import service from '@/utils/request/index'
import type { AddOrUpdateTagDto, BackendTagListItemDto, BackendTagSearchParams } from './types'
import type { BackendServicePageResult } from '@/utils/request/types'
// 后台管理 积分商城相关接口

/**
 * 商品配置列表
 */
export const getShopItemList = (params: BackendTagSearchParams) => {
  return service.request<BackendServicePageResult<BackendTagListItemDto>>({
    url: '/api/culture/shop/item/productList',
    method: 'POST',
    data: params,
  })
}

/**
 * 新增/编辑商品
 */
export const addOrUpdateShopItem = (data: AddOrUpdateTagDto) => {
  return service.request<BackendServicePageResult<BackendTagListItemDto>>({
    url: '/api/culture/shop/item/addOrUpdate',
    method: 'POST',
    data,
  })
}

/*
 * 删除商品
 */
export const deleteShopItem = (id: number) => {
  return service.request({
    url: `/api/culture/shop/item/deleteProduct?id=${id}`,
    method: 'POST',
  })
}
/**
 * 后台商品领用列表
 */
export const getBackendExchangeList = (data: BackendTagSearchParams) => {
  return service.request<BackendServicePageResult<BackendTagListItemDto>>({
    url: '/api/culture/shop/order/background/productList',
    method: 'POST',
    data,
  })
}

/**
 * 发放 取消发放
 */
export const issueProduct = (data) => {
  return service.request({
    url: `/api/culture/shop/order/issueProduct`,
    method: 'POST',
    data,
  })
}
