import service from '@/utils/request/index'
import type { CarouselItemDto, UserAccountDataDto, UserRecordDataDto } from './types'
import { BooleanFlag } from '@/constants'
/**
 * 获取首页轮播图列表
 */
export const getCarouselList = () => {
  return service.request<CarouselItemDto[]>({
    url: '/api/cultureCarousel/listNoPage',
    method: 'POST',
    data: {
      isRelease: BooleanFlag.YES,
    },
  })
}

/**
 * 获取首页用户相关数据 亚币 等级等
 */
export const getUserAccountData = () => {
  return service.request<UserAccountDataDto>({
    url: '/api/personalCenter/selfAccountData',
    method: 'POST',
    data: {},
  })
}

/**
 * 获取首页信息 是否已经签到
 */

export const getRecordData = () => {
  return service.request<UserRecordDataDto>({
    url: '/api/culture/action/record/baseData',
    method: 'POST',
    data: {},
  })
}
