import { defineStore } from 'pinia'
import { getUserQestionNum } from '@/api'

/**
 * 问吧数据
 */
export const useQuestionStore = defineStore('question', () => {
  const userQestionNum = ref<number>(0)

  const fetchUserQestionNum = async () => {
    try {
      const { data } = await getUserQestionNum()
      userQestionNum.value = data
    } catch (error) {
      console.error(error)
    }
  }
  return { userQestionNum, fetchUserQestionNum }
})
