import service from '@/utils/request/index'
import type { BackendServicePageResult, PageSearchParams } from '@/utils/request/types'
import type { ExchangeGoodsParams, ShopItemDto, ShopSearchParams, YaBiData } from './types'
/**
 * 积分商城列表
 */
export const getShopItemList = (data: ShopSearchParams) => {
  return service.request<BackendServicePageResult<ShopItemDto>>({
    url: '/api/culture/shop/item/pageList',
    method: 'POST',
    data,
  })
}

/**
 * 获取用户YA币兑换记录
 */
export const getYabiExchangeList = (data: PageSearchParams) => {
  return service.request<BackendServicePageResult<any>>({
    url: '/api/culture/action/record/yabiList',
    method: 'POST',
    data,
  })
}

/**
 * 获取用户亚币相关数据
 */
export const getYaBiData = () => {
  return service.request<YaBiData>({
    url: '/api/culture/action/record/yabiData',
    method: 'POST',
    data: {},
  })
}

/**
 * 兑换商品
 */
export const exchangeGoods = (data: ExchangeGoodsParams) => {
  return service.request({
    url: '/api/culture/shop/item/exchange',
    method: 'POST',
    data,
  })
}
