import type { PageSearchParams } from '@/utils/request/types'
import { ShopGoodsTypeEnum } from '@/constants'

/**
 * 请求参数类型
 */
export interface ShopSearchParams extends PageSearchParams {
  region: string
  itemType: ShopGoodsTypeEnum
}

/**
 * 积分商城商品类型
 */
export interface ShopItemDto {
  id: number
  description: string
  enable: number
  imageUrl: string
  itemType: number
  itemTypeName: string
  name: string
  price: number
  region: string
  soldOut: boolean
  sotrOrder: number
  stock: number
}

/**
 * yabi信息对象类型
 */
export interface YaBiData {
  currentValue: number
}

/**
 * 兑换商品请求参数类型
 */
export interface ExchangeGoodsParams {
  itemId: number
  num: number
  deliveryInfo?: string
}
