import service from '@/utils/request/index'
import type { BooleanFlag } from '@/constants'
import type { OtherUserInfoDto } from '@/types'

// 其他用户页面数据

/**
 * 获取其他用户的用户信息
 */
export const getOtherUserData = (data: { userId: string; isReal: BooleanFlag }) => {
  return service.request<OtherUserInfoDto>({
    url: '/api/personalCenter/userData',
    method: 'POST',
    data,
  })
}

/**
 * 显示其他用户的发帖数据
 */
export const getOtherUserPostData = (data: {
  createUserId: string
  isReal: BooleanFlag
  current: number
  size: number
}) => {
  return service.request({
    url: '/api/personalCenter/getUserArticleData',
    method: 'POST',
    data,
  })
}
