import { defineStore } from 'pinia'
import { getColumnOptions } from '@/api'
import type { ColumnOptionDto } from '@/api/article/types'

/**
 * 关于专栏的不分页数据
 */
export const useColumnStore = defineStore('column', () => {
  const columnList = ref<ColumnOptionDto[]>([])

  let isLoading = false

  const fetchColumnList = async () => {
    if (isLoading) return
    isLoading = true
    try {
      const { data } = await getColumnOptions()
      columnList.value = data
      console.log(columnList.value, 'columnList')
    } catch (error) {
      console.error(error)
    } finally {
      isLoading = false
    }
  }
  fetchColumnList()
  return { columnList, fetchColumnList }
})
