// 常规的接口
// import service from '@/utils/request/index'
// import type { FielItemDto } from './types'
/**
 * 获取常规的接口
 */
// export const uploadFile = (file: File, onProgress?: (progress: number) => void) => {
//   const formData = new FormData()
//   formData.append('file', file)
//   return service.request<FielItemDto>({
//     url: '/mobiles/file-upload/singleUpload',
//     method: 'POST',
//     data: formData,
//     onUploadProgress: (progressEvent) => {
//       const percentCompleted = Math.round((progressEvent.loaded * 100) / (progressEvent.total || 1))
//       onProgress?.(percentCompleted)
//     },
//   })
// }

/**
 * 暂时调用oa正式接口
 */
import axios, { type AxiosRequestConfig } from 'axios'
type UploadFileResponseItem = {
  createTime: string
  createUser: number
  fileBucket: string
  fileId: string
  fileName: string
  filePath: string
  fileSizeKb: number
  fileSuffix: string
  finalName: string
  realPath: string
  updateTime: string
  updateUser: string
}

// 单个文件上传
export const uploadFile = (
  file: File,
  options: {
    onProgress?: (progress: number) => void
  } = {},
): {
  cancel: () => void
  promise: Promise<UploadFileResponseItem>
} => {
  const formData = new FormData()
  formData.append('fileList', file)

  const { onProgress } = options

  const controller = new AbortController()
  const axiosOptions: AxiosRequestConfig = {
    signal: controller.signal,
  }

  if (onProgress) {
    axiosOptions.onUploadProgress = (progressEvent) => {
      const percentCompleted = Math.round((progressEvent.loaded * 100) / (progressEvent.total || 1))
      onProgress?.(percentCompleted)
    }
  }

  return {
    cancel: () => {
      controller.abort()
    },
    promise: axios
      .post('http://47.112.96.71:8082/mobiles/uploadFile', formData, axiosOptions)
      .then((data) => data.data.data[0] as UploadFileResponseItem),
  }
}
