import { AuditStatusEnum } from '@/constants'
import type { PageSearchParams } from '@/utils/request/types'

// 我的发布 详情
export interface SelfPublishDetailDto {
  collectionCount: number
  content: string
  createTime: number
  createUserId: number
  description: string
  faceUrl: string
  hasPraised: boolean
  id: number
  isRecommend: boolean
  isRelateColleague: boolean
  praiseCount: number
  releaseStatus: number
  replyCount: number
  tagNameList: string[]
  title: string
  type: string
  videoUrl: string
  viewCount: number
}

// 我的草稿 详情
export interface SelfDraftDetailDto {
  id: number
  title: string
  content: string
  createTime: string
  updateTime: string
}

export interface UpdateUserInfoDto {
  hiddenAvatar: string
  hiddenName: string
  signature: string
}

// 审核列表查询参数
export interface AuditListSearchParams extends PageSearchParams {
  isAudit: AuditStatusEnum
}

// 待审核列表item
export interface AuditListItemDto {
  collectionCount: number
  content: string
  createTime: number
  createUserId: number
  description: string
  faceUrl: string
  hasPraised: boolean
  id: number
  imgUrl: string
  isRecommend: boolean
  isRelateColleague: boolean
  playCount: number
  praiseCount: number
  relateColumnId: string
  releaseStatus: AuditStatusEnum
  replyCount: number
  showAvatar: string
  showName: string
  tagNameList: string[]
  title: string
  type: string
  viewCount: number
}

/**
 * 审核推文参数
 */
export interface AuditArticleDto {
  articleId: number
  auditResult: Exclude<AuditStatusEnum, AuditStatusEnum.UNAUDITED>
}
