import { ArticleTypeEnum, ReleaseStatusTypeEnum, BooleanFlag, SendTypeEnum } from '@/constants'
import type { PageSearchParams } from '@/utils/request/types'

/**
 * 搜索文章的参数
 */
export interface ArticleSearchParams extends PageSearchParams {
  type?: ArticleTypeEnum
  sortLogic?: number
}

/**
 * 添加或更新文章DTO（带枚举版本）
 */
export type AddOrUpdateArticleDto =
  | AddOrUpdatePostDto
  | AddOrUpdateColumnDto
  | AddOrUpdateInterviewDto

/**
 * 添加帖子的DTO
 */
export interface AddOrUpdatePostDto {
  id?: number
  title: string
  content: string
  releaseStatus: ReleaseStatusTypeEnum
  sendType: SendTypeEnum
  faceUrl?: string
  imgUrl?: string
  sendTime?: string
  type: ArticleTypeEnum.POST
}

interface AddOrUpdateColumnBase {
  id?: number
  type: ArticleTypeEnum.COLUMN
  title: string
  content: string
  releaseStatus: ReleaseStatusTypeEnum
  sendType: SendTypeEnum
  faceUrl?: string
  imgUrl?: string
  // 关联的专栏栏目
  relateColumnId?: number
  mainTagId: string
  isRelateColleague: BooleanFlag
  sendTime?: string
  isRecommend: BooleanFlag
}

/**
 * 添加专栏的原始form类型
 */
export interface AddOrUpdateColumnForm extends AddOrUpdateColumnBase {
  tagList: number[]
}

/**
 * 添加专栏的DTO
 */
export interface AddOrUpdateColumnDto extends AddOrUpdateColumnBase {
  tagList: { tagId: number; sort: number }[]
}

export interface AddOrUpdateInterviewBase {
  id?: number
  type: ArticleTypeEnum.INTERVIEW
  title: string
  content: string
  releaseStatus: ReleaseStatusTypeEnum
  sendType: SendTypeEnum
  faceUrl?: string
  imgUrl?: string
  // 关联的专访栏目
  relateColumnId?: number
  mainTagId: string
  sendTime?: string
  isRecommend: BooleanFlag
}

export interface AddOrUpdateInterviewForm extends AddOrUpdateInterviewBase {
  tagList: number[]
}

/**
 * 添加专访的DTO
 */
export interface AddOrUpdateInterviewDto extends AddOrUpdateInterviewBase {
  tagList: { tagId: number; sort: number }[]
}

/**
 * 添加专访的DTO
 */

/**
 *  文章详情
 */

export interface ArticleItemDto {
  id: number
  title: string
  content: string
  faceUrl: string
  videoUrl: string
  description: string
  createUserId: number
  createTime: number
  viewCount: number
  isRecommend: BooleanFlag
  type: ArticleTypeEnum
  isRelateColleague: BooleanFlag
  releaseStatus: ReleaseStatusTypeEnum
  tagNameList: string[]
  praiseCount: number
  collectionCount: number
  replyCount: number
  hasPraised: boolean
  hasCollect: boolean
  imgUrl: string
  createUserAvatar: string
  createUserName: string
}

/**
 * 专栏选项
 */
export interface ColumnOptionDto {
  color: string
  createTime: number
  createUserId: number
  id: number
  isDelete: BooleanFlag
  sort: number
  status: BooleanFlag
  title: string
  type: 'column'
}

/**
 * 专栏列表Item
 */
export interface ColumnItemDto {
  title: string
  color: string
  sort: number
  yaColumnVoList: {
    articleId: number
    collectCount: number
    content: string
    createTime: number
    description: string
    faceUrl: string
    hasPraised: boolean
    isRecommend: number
    praiseCount: number
    replyCount: number
    title: string
    type: ArticleTypeEnum.COLUMN
    viewCount: number
  }[]
}

/**
 * 专访选项
 */
export interface InterviewOptionDto {
  color: string
  createTime: number
  createUserId: number
  id: number
  isDelete: BooleanFlag
  sort: number
  status: BooleanFlag
  title: string
  type: 'column'
}

/**
 * 专访列表Item
 */
export interface InterviewItemDto {
  title: string
  color: string
  sort: number
  yaColumnVoList: {
    articleId: number
    collectCount: number
    content: string
    createTime: number
    description: string
    faceUrl: string
    hasPraised: boolean
    isRecommend: number
    praiseCount: number
    replyCount: number
    title: string
    type: ArticleTypeEnum.INTERVIEW
    viewCount: number
  }[]
}
/**
 * 评论列表
 */
export interface CommentSearchParams extends PageSearchParams {
  articleId: number | string
}

/**
 * 新增评论
 */
export interface AddCommentDto {
  articleId: number | string
  content: string
  pId?: number | string
}

/**
 * 评论信息
 */
export interface CommentItemDto {
  articleId: number
  avatar: string
  children: CommentItemDto[]
  content: string
  createTime: number
  hasPraise: BooleanFlag
  hiddenAvatar: string
  hiddenName: string
  id: number
  isFeatured: number
  isTop: number
  pid: number
  postPriseCount: number
  region: string
  regionHide: number
  replyUser: string
  userId: number
}
