import { ArticleTypeEnum, ReleaseStatusTypeEnum, BooleanFlag, SendTypeEnum } from '@/constants'
import type { PageSearchParams } from '@/utils/request/types'

/**
 * 添加或更新实践DTO
 */
export interface AddOrUpdatePracticeDto {
  id?: number
  title: string
  content: string
  faceUrl: string
  imgUrl: string
  releaseStatus: ReleaseStatusTypeEnum
  mainTagId: number | string
  tagList: { tagId: number; sort: number }[]
  sendType: SendTypeEnum
  sendTime: string
}

/**
 * 搜索文章的参数
 */
export interface PracticeSearchParams extends PageSearchParams {
  sortLogic?: number
}

/**
 * 添加或更新文章DTO（带枚举版本）
 */
export interface AddOrUpdateArticleDto {
  /** 内容 */
  content?: string

  /** 创建人id */
  createUserId?: number

  /** 描述 */
  description?: string

  /** 封面图 */
  faceUrl?: string

  /** id，编辑时必传 */
  id?: number

  /** 是否关联同事 */
  isRelateColleague?: number

  /** 主标签id */
  mainTagId?: number

  /** 发布状态 */
  releaseStatus?: ReleaseStatusTypeEnum

  /** 标签列表 */
  tagList?: { tagId: number; sort: number }[]

  /** 标题 */
  title?: string

  /** 文章类型 */
  type?: ArticleTypeEnum

  /** 视频url */
  videoUrl?: string
}

/**
 *  文章详情
 */

// 更严格的类型定义
export interface ArticleItemDto {
  id: number
  title: string
  content: string
  faceUrl: string
  videoUrl: string
  description: string
  createUserId: number
  createTime: number
  viewCount: number
  isRecommend: BooleanFlag
  type: ArticleTypeEnum
  isRelateColleague: BooleanFlag
  releaseStatus: ReleaseStatusTypeEnum
  tagNameList: string[]
  praiseCount: number
  collectionCount: number
  replyCount: number
  hasPraised: BooleanFlag
}

/**
 * 实践列表item
 */
export interface PracticeItemDto {
  collectionCount: number
  content: string
  createTime: number
  createUserId: number
  description: string
  faceUrl: string
  hasPraised: boolean
  id: number
  isRecommend: BooleanFlag
  praiseCount: number
  releaseStatus: ReleaseStatusTypeEnum
  replyCount: number
  showAvatar: string
  showName: string
  tagNameList: string[]
  title: string
  type: ArticleTypeEnum.PRACTICE
  viewCount: number
}
