interface UseHintAnimationOptions {
  classes?: string[] // 一次加多个过度类 shortcuts
  duration?: number // 动画时长
}
// 用js模拟dom元素的 hover 效果
export const useHintAnimation = (
  el: MaybeRef<HTMLElement | null>,
  { classes = [], duration = 200 }: UseHintAnimationOptions = {},
) => {
  let timer: number | null = null
  const triggerAnimation = () => {
    const dom = unref(el)
    if (!dom) return
    // 清除旧动画，以防连点失效
    if (timer) {
      classes.forEach((cls) => dom.classList.remove(cls))
      clearTimeout(timer)
    }

    // 添加动画类
    classes.forEach((cls) => dom.classList.add(cls))

    // 动画结束后移除
    timer = setTimeout(() => {
      classes.forEach((cls) => dom.classList.remove(cls))
      timer = null
    }, duration)
  }
  return { triggerAnimation }
}
