import { defineStore } from 'pinia'
import { getTagList } from '@/api'
import type { TagItemDto } from '@/api/tag/types'
/**
 * 关于标签的store
 */
export const useTagsStore = defineStore('tags', () => {
  const tagList = ref<TagItemDto[]>([])
  let isLoading = false

  const fetchTagList = async () => {
    if (isLoading) return
    isLoading = true
    try {
      const { data } = await getTagList()
      tagList.value = data
      console.log(tagList.value, 'tagList')
    } catch (error) {
      console.error(error)
    } finally {
      isLoading = false
    }
  }
  // 手动调用一次
  fetchTagList()

  return { tagList, fetchTagList }
})
