import service from '@/utils/request/index'
import type {
  AddOrUpdateArticleDto,
  ArticleItemDto,
  ArticleSearchParams,
  InterviewOptionDto,
  ColumnOptionDto,
  AddCommentDto,
  CommentItemDto,
  CommentSearchParams,
  InterviewItemDto,
  ColumnItemDto,
  VideoOptionDto,
  CommentChildrenSearchParams,
} from './types'
import type { BackendServicePageResult, PageSearchParams } from '@/utils/request/types'

// 文章相关的接口(帖子 视频 实践等)

/**
 * 发布文章 暂时由 有帖子 专栏 专访
 */
export const addOrUpdateArticle = (data: AddOrUpdateArticleDto) => {
  return service.request<boolean>({
    url: '/api/cultureArticle/addOrUpdateArticle',
    method: 'POST',
    data,
  })
}

/**
 * 文章列表
 */
export const getArticleList = (data: ArticleSearchParams) => {
  return service.request<BackendServicePageResult<ArticleItemDto>>({
    url: '/api/cultureArticle/listByPage',
    method: 'POST',
    data,
  })
}

/**
 * 文章详情
 */
export const getArticleDetail = (articleId: number | string) => {
  return service.request<ArticleItemDto>({
    url: `/api/cultureArticle/getArticleDetail?articleId=${articleId}`,
    method: 'POST',
  })
}

/**
 * 获取专访列表选项 --不分页 用户新增时候选择
 */
export const getInterviewOptions = () => {
  return service.request<InterviewOptionDto[]>({
    url: '/api/cultureColumn/listNoPage?type=interview',
    method: 'POST',
  })
}

/**
 * 获取首页专访列表list —— 分页
 */
export const getInterviewList = (data: PageSearchParams) => {
  return service.request<BackendServicePageResult<InterviewItemDto>>({
    url: '/api/yaCulture/listByPage',
    method: 'POST',
    data: {
      ...data,
      type: 'interview',
    },
  })
}

/**
 * 获取专栏列表选项-- 不分页 用户新增时候选择
 */
export const getColumnOptions = () => {
  return service.request<ColumnOptionDto[]>({
    url: '/api/cultureColumn/listNoPage?type=column',
    method: 'POST',
  })
}

/**
 * 获取视频栏目列表 --不分页 用户新增的时候传
 */
export const getVideoOptions = () => {
  return service.request<VideoOptionDto[]>({
    url: '/api/cultureColumn/listNoPage?type=video',
    method: 'POST',
  })
}

/**
 * 获取首页专栏列表list —— 分页
 */
export const getColumnList = (data: PageSearchParams) => {
  return service.request<BackendServicePageResult<ColumnItemDto>>({
    url: '/api/yaCulture/listByPage',
    method: 'POST',
    data: {
      ...data,
      type: 'column',
    },
  })
}

/**
 * 获取首页视频列表list —— 分页
 */
export const getVideoList = (data: PageSearchParams) => {
  return service.request<BackendServicePageResult<ColumnItemDto>>({
    url: '/api/yaCulture/listByPage',
    method: 'POST',
    data: {
      ...data,
      type: 'video',
    },
  })
}

/**
 * 点赞或者取消点赞文章
 */
export const addOrCanceArticlelLike = (articleId: number | string) => {
  return service.request<boolean>({
    url: `/api/cultureArticle/likeArticle?articleId=${articleId}`,
    method: 'POST',
  })
}

/**
 * 收藏或者取消收藏文章
 */
export const addOrCanceArticlelCollect = (articleId: number | string) => {
  return service.request<boolean>({
    url: `/api/cultureArticle/collectArticle?articleId=${articleId}`,
    method: 'POST',
  })
}

/**
 * 获取评论列表
 */
export const getCommentList = (data: CommentSearchParams) => {
  return service.request<BackendServicePageResult<CommentItemDto>>({
    url: `/api/cultureComment/getComment`,
    method: 'POST',
    data,
  })
}

/**
 * 新增评论
 */
export const addComment = (data: AddCommentDto) => {
  return service.request<boolean>({
    url: `/api/cultureComment/addComment`,
    method: 'POST',
    data,
  })
}

/**
 * 点赞评论
 */
export const addOrCancelCommentLike = (commentId: number | string) => {
  return service.request<boolean>({
    url: `/api/cultureComment/likeComment?commentId=${commentId}`,
    method: 'POST',
  })
}

/**
 * 修改文章的是否推荐/置顶字段
 */
export const updateArticleRecommend = (articleId: number) => {
  return service.request({
    url: `/api/cultureArticle/isRecommend?articleId=${articleId}`,
    method: 'POST',
    data: {},
  })
}

/**
 * 删除文章接口
 */
export const deleteArticle = (id: number) => {
  return service.request({
    url: `/api/personalCenter/deleteArticle`,
    method: 'POST',
    data: {
      id,
    },
  })
}

/**
 * 删除评论接口
 */
export const deleteComment = (commentId: number) => {
  return service.request({
    url: `/api/cultureComment/deleteComment?commentId=${commentId}`,
    method: 'POST',
  })
}

/**
 * 给文章投币
 */

export const addOrCancelArticleReward = (data: { articleId: number; ayabi: number }) => {
  return service.request({
    url: `/api/culture/action/record/reward`,
    method: 'POST',
    data,
  })
}

/**
 * 给视频播放量加1
 */
export const addVideoPlayCount = (articleId: number) => {
  return service.request({
    url: `/api/cultureArticle/addVideoPlayCount?articleId=${articleId}`,
    method: 'POST',
  })
}

/**
 * 展开评论 获取子评论 分页
 */
export const getCommentChildren = (data: CommentChildrenSearchParams) => {
  return service.request<BackendServicePageResult<CommentItemDto>>({
    url: `/api/cultureComment/comment/children`,
    method: 'POST',
    data,
  })
}
