import { createRouter, createWebHistory } from 'vue-router'
import layoutCulture from '@/layoutCulture/index.vue'
import { scrollBehavior } from './scrollStorage'
import { registerRouterGuards } from './guards'
const routes = [
  {
    path: '/',
    name: 'Layout',
    component: layoutCulture,
    redirect: '/homePage/homeTab',
    meta: {
      title: '企业文化首页',
    },
    children: [
      {
        path: 'homePage',
        name: 'CultureHomePage',
        // component: () => import('@/layoutCulture/components/mainContainer.vue'),
        component: () => import('@/views/homePage/index.vue'),
        children: [
          {
            path: 'homeTab',
            name: 'CultureHomeTab',
            component: () => import('@/views/homePage/homeTab/index.vue'),
          },
          {
            path: 'yaTab',
            name: 'CultureYaTab',
            component: () => import('@/views/homePage/yaTab/index.vue'),
          },
          {
            path: 'askTab',
            name: 'CultureAskTab',
            component: () => import('@/views/homePage/askTab/index.vue'),
          },
        ],
      },
      {
        path: 'videoDetail/:id',
        name: 'CultureVideoDetail',
        component: () => import('@/views/videoDetail/index.vue'),
      },
      {
        path: 'pointsStore',
        name: 'CulturePointsStore',
        component: () => import('@/views/pointsStore/index.vue'),
      },
      {
        path: 'articleDetail/:articleId',
        name: 'CultureArticleDetail',
        component: () => import('@/views/articleDetail/index.vue'),
      },
      // 发布视频
      {
        path: 'publishVideo',
        name: 'CulturePublishVideo',
        component: () => import('@/views/publishVideo/index.vue'),
      },
      // 个人中心
      {
        path: 'userPage',
        name: 'CultureUserPage',
        component: () => import('@/views/userPage/index.vue'),
      },
      // 去投稿
      {
        path: 'publishCase',
        name: 'CulturePublishCase',
        component: () => import('@/views/publishCase/index.vue'),
      },
      // 搜索页面
      {
        path: 'searchPage',
        name: 'CultureSearchPage',
        component: () => import('@/views/searchPage/index.vue'),
      },
      // 审核
      {
        path: 'auditArticle/:id',
        name: 'CultureAuditArticle',
        component: () => import('@/views/auditArticle/index.vue'),
      },
      // 发布文章
      // {
      // {
      //   path: 'deshboard',
      //   name: 'CultureHome',
      //   component: () => import('@/views/home/index.vue')
      // },
      // {
      //   path: 'ya',
      //   name: 'CultureYa',
      //   component: () => import('@/views/ya/index.vue')
      // },
      // {
      //   path: 'ask',
      //   name: 'CultureAsk',
      //   component: () => import('@/views/ask/index.vue')
      // }
    ],
  },
  {
    path: '/test',
    name: 'Test',
    component: () => import('@/test.vue'),
  },
  {
    path: '/backend',
    name: 'Backend',
    component: () => import('@/views/backend/index.vue'),
    redirect: '/backend/manager',
    children: [
      {
        path: 'manager',
        name: 'ManagerManagement',
        component: () => import('@/views/backend/manager/index.vue'),
        meta: { title: '企业文化管理员' },
      },
      {
        path: 'tags',
        name: 'OfficialManagement',
        component: () => import('@/views/backend/tags/index.vue'),
        meta: { title: '官方标签' },
      },
      {
        path: 'carousel',
        name: 'CarouselManagement',
        component: () => import('@/views/backend/carousel/index.vue'),
        meta: { title: '轮播图设置' },
      },
      // {
      //   path: 'topic-admin',
      //   name: 'TopicAdminManagement',
      //   component: () => import('@/views/backend/topic-admin/index.vue'),
      //   meta: { title: '专栏——管理员' },
      // },
      {
        path: 'columnSettings',
        name: 'ColumnSettingsManagement',
        component: () => import('@/views/backend/columnSettings/index.vue'),
        meta: { title: '专栏——栏目管理' },
      },
      // {
      //   path: 'interview-admin',
      //   name: 'InterviewAdminManagement',
      //   component: () => import('@/views/backend/interview-admin/index.vue'),
      //   meta: { title: '专访——管理员' },
      // },
      {
        path: 'interviewSettings',
        name: 'InterviewSettingsManagement',
        component: () => import('@/views/backend/interviewSettings/index.vue'),
        meta: { title: '专访——栏目管理' },
      },
      {
        path: 'videoSettings',
        name: 'VideoSettingsManagement',
        component: () => import('@/views/backend/videoSettings/index.vue'),
        meta: { title: '视频——栏目管理' },
      },
      {
        path: 'videoManage',
        name: 'VideoManageManagement',
        component: () => import('@/views/backend/videoManage/index.vue'),
        meta: { title: '视频管理' },
      },
      {
        path: 'caseManage',
        name: 'CaseManageManagement',
        component: () => import('@/views/backend/caseManage/index.vue'),
        meta: { title: 'YAYA案例库管理' },
      },
      {
        path: 'goodsManage',
        name: 'GoodsManageManagement',
        component: () => import('@/views/backend/goodsManage/index.vue'),
        meta: { title: '积分商城——商品配置' },
      },
      {
        path: 'goodsDistribution',
        name: 'GoodsDistributionManagement',
        component: () => import('@/views/backend/goodsDistribution/index.vue'),
        meta: { title: '积分商城——商品分发' },
      },
    ],
  },
]

const router = createRouter({
  history: createWebHistory(import.meta.env.BASE_URL),
  routes,
  // scrollBehavior(to, from, savedPosition) {
  //   return new Promise((resolve) => {
  //     // console.log(to, from, savedPosition)
  //     // 如果有浏览器保存的位置（前进/后退），优先使用
  //     if (savedPosition) {
  //       resolve(savedPosition)
  //       return
  //     }

  //     // 如果有锚点，滚动到锚点
  //     if (to.hash) {
  //       resolve({ el: to.hash })
  //       return
  //     }

  //     // 检查是否有保存的滚动位置
  //     const savedScrollY = scrollPositionMap.get(to.fullPath)
  //     if (savedScrollY !== undefined) {
  //       resolve({ top: savedScrollY })
  //       return
  //     }

  //     // 默认滚动到顶部
  //     resolve({ top: 0 })
  //   })
  // },
  scrollBehavior,
})
// 在路由离开前保存当前滚动位置
// router.beforeEach((to, from, next) => {
//   // 保存当前页面的滚动位置
//   if (from.fullPath) {
//     scrollPositionMap.set(from.fullPath, window.scrollY)
//   }
//   next()
// })
registerRouterGuards(router)
export default router
