import service from '@/utils/request/index'
import type { AddOrUpdateTagDto, BackendTagListItemDto, BackendTagSearchParams } from './types'
import type { BackendServicePageResult } from '@/utils/request/types'
// 后台管理案例库相关接口

/**
 * 案例库后台列表
 */
export const getCaseList = (data: PageSearchParams) => {
  return service.request<BackendServicePageResult<BackendTagListItemDto>>({
    url: '/api/cultureCase/caseAuditByPage',
    method: 'POST',
    data,
  })
}

/**
 * 添加轮播图
 */
export const addCarousel = (data: AddOrUpdateCarouselDto) => {
  return service.request({
    url: '/api/cultureCarousel/addCarousel',
    method: 'POST',
    data,
  })
}

/**
 * 审核接口
 */
export const auditCase = (data: AddOrUpdateCarouselDto) => {
  return service.request({
    url: '/api/cultureCase/auditCase',
    method: 'POST',
    data,
  })
}

/**
 * 删除案例库
 */
export const deleteCase = (id: number) => {
  return service.request({
    url: `/api/cultureCase/deleteCase?id=${id}`,
    method: 'POST',
  })
}
