import { defineStore } from 'pinia'

import { getTagList } from '@/api'

/**
 * 关于标签的store
 */
export const useTagsStore = defineStore('tags', () => {
  const tagList = ref<{ label: string; value: number }[]>([])

  const fetchTagList = async () => {
    const { data } = await getTagList()
    tagList.value = data.map((item) => ({
      label: item.title,
      value: item.id,
    }))
  }

  return { tagList, fetchTagList }
})
