/**
 * 确认兑换商品的弹窗内容
 */
import { ShopGoodsTypeEnum, regionListOptions } from '@/constants'
import type { ExchangeGoodsParams, ShopItemDto } from '@/api'
import type { SetupContext } from 'vue'
import ask from '@/assets/img/culture/ask.png'

type ExchangeContentProps = {
  item: ShopItemDto
  modelValue: ExchangeGoodsParams
}
type ExchangeContentEvents = {
  'update:modelValue'(data: ExchangeGoodsParams): void
}

export default function ExchangeContent(
  { item, modelValue }: ExchangeContentProps,
  context: SetupContext<ExchangeContentEvents>,
) {
  return (
    <div class="exchange-content py-6 px-4">
      {/* 商品图片区域 */}
      <div class="flex justify-center mb-8">
        <div class="relative">
          <div class="w-32 h-32 bg-gradient-to-br from-orange-100 to-pink-100 rounded-3xl flex items-center justify-center shadow-lg">
            <div class="w-20 h-20 bg-white rounded-lg flex items-center justify-center shadow-sm">
              <img src={ask} alt={item.name} class="w-16 h-16 object-contain" />
            </div>
          </div>
          <div class="absolute -top-2 -right-2 w-7 h-7 bg-blue-500 rounded-full flex items-center justify-center shadow-md">
            <span class="text-white text-sm font-medium">6</span>
          </div>
        </div>
      </div>

      {/* 商品信息 */}
      <div class="space-y-3 mb-8">
        <div class="flex items-center gap-3 px-4">
          <div class="w-1.5 h-1.5 bg-gray-400 rounded-full flex-shrink-0"></div>
          <span class="text-gray-600 text-sm min-w-12">名称：</span>
          <span class="font-medium text-gray-900 flex-1">{item.name}</span>
        </div>

        <div class="flex items-center gap-3 px-4">
          <div class="w-1.5 h-1.5 bg-orange-400 rounded-full flex-shrink-0"></div>
          <span class="text-gray-600 text-sm min-w-12">积分：</span>
          <span class="font-semibold text-orange-500 text-lg">{item.price}YA币</span>
        </div>
      </div>

      {/* 办公点选择和数量 */}
      {item.itemType === ShopGoodsTypeEnum.REAL_GOODS && (
        <div class=" rounded-lg px-5 mx-2 space-y-4">
          {/* 办公点选择 */}
          <div>
            <label class="text-gray-700 text-sm font-medium mb-2 block">办公点</label>
            <el-select
              modelValue={modelValue.deliveryInfo}
              onUpdate:modelValue={(value: string) =>
                context.emit('update:modelValue', { ...modelValue, deliveryInfo: value })
              }
              placeholder="请选择办公点"
              class="w-full"
            >
              {regionListOptions.map((office) => (
                <el-option key={office.value} label={office.label} value={office.value} />
              ))}
            </el-select>
          </div>

          {/* 数量选择 */}
          <div>
            <label class="text-gray-700 text-sm font-medium mb-2 block">选择数量</label>
            <el-input-number
              min={1}
              modelValue={modelValue.num}
              onUpdate:modelValue={(value: number) =>
                context.emit('update:modelValue', { ...modelValue, num: value })
              }
              class="w-full"
              controls-position="right"
            />
          </div>
        </div>
      )}
    </div>
  )
}

ExchangeContent.props = {
  item: {
    type: Object as PropType<ShopItemDto>,
    required: true,
  },
  modelValue: {
    type: Object as PropType<ExchangeGoodsParams>,
    required: true,
  },
}

ExchangeContent.emits = {
  'update:modelValue': (value: ExchangeGoodsParams) => value,
}
