import type { TagItemDto } from '@/api/case/types'
import { UsageStatusEnum, AuditStatusEnum } from '@/constants'
import type { PageSearchParams } from '@/utils/request/types'

export interface CaseListSearchParams extends PageSearchParams {
  isAudit?: AuditStatusEnum
  isUse?: UsageStatusEnum
  title?: string
}

type TagItem = {
  id: number
  title: string
}
export interface BackendCaseListItemDto {
  caseType: string
  content: string
  createTime: number
  createUser: number
  cultureKeywordMain: TagItem[]
  cultureKeywordSecond: TagItem[]
  cultureRelation: string
  dataSources: number
  depIdList: string[]
  depNameList: string[]
  deptId: string
  deptName: string
  id: number
  integrity: string
  isAudit: number
  isDelete: number
  isDispose: number
  isUse: number
  mainScene: string
  minorScene: string
  number: string
  sceneKeywordMain: TagItem[]
  sceneKeywordSecond: TagItem[]
  sourceProject: string
  sourceTime: number
  sourceType: string
  sourceUser: number
  title: string
  yearKeywordMain: TagItem[]
  yearKeywordSecond: TagItem[]
  sourceUserName: string
  sourceUserWorkNo: string
}
export interface BackendEditCaseDto {
  id: number
  sourceProject: string
  sourceType: string
  caseType: string
  integrity: string
  cultureRelation: string
  title: string
  content: string
  deptId: string
  deptName: string
  tagRelationDtoList: TagItemDto[]
}

export interface ChangeUsageStatusDto {
  id: number
  isUse: UsageStatusEnum
}

export interface AuditCaseDto {
  id: number
  isAudit: AuditStatusEnum
}
