import type { SetupContext } from 'vue'

type TypeOfValue = string | number
interface TabsProps<T> {
  tabs: {
    label: string
    value: T
  }[]
  modelValue: T
}

interface TabsEmits<T> {
  'update:modelValue': [T]
  change: [T]
}

const BASE_TAB_CALASSES =
  'tab-item cursor-pointer bg-#d9effd/80 rounded-lg flex items-center justify-center px-4 py-2 min-w-20 h-8 transition-all duration-300 hover:shadow-md hover:bg-blue-100 hover:text-blue-700 hover:-translate-y-0.5 active:scale-95 font-medium text-14px text-gray-700 shadow-sm border border-blue-100'

const ACTIVE_TAB_CLASSES =
  ' !bg-gradient-to-r !from-[#3b82f6]/90 !to-[#60a5fa]/90 !shadow-lg transform -translate-y-1 !text-white !border-transparent'

//       <div class="left flex gap-3"> 未设置排列方式 需要给父组件设置 flex布局
export default function Tabs<T extends TypeOfValue>(
  { tabs, modelValue }: TabsProps<T>,
  { emit }: SetupContext<TabsEmits<T>>,
) {
  return tabs.map((tab) => (
    <div
      key={tab.value}
      class={[
        BASE_TAB_CALASSES,
        {
          [ACTIVE_TAB_CLASSES]: modelValue === tab.value,
        },
      ]}
      onClick={() => {
        emit('update:modelValue', tab.value)
        emit('change', tab.value)
      }}
    >
      {tab.label}
    </div>
  ))
}
