import type { PageSearchParams } from '@/utils/request/types'
import { ShopGoodsTypeEnum } from '@/constants'
export interface BackendShopListSearchParams extends PageSearchParams {
  name?: string
  itemType?: ShopGoodsTypeEnum
  region?: string
  enable?: 0 | 1
}
export interface BackendShopItemDto {
  createTime: number
  deliveryInfo: string
  id: number
  imageUrl: string
  isDelete: null
  issueTime: number
  issuerId: number
  issuerName: string
  itemId: number
  itemName: string
  itemType: ShopGoodsTypeEnum
  memo: string
  num: number
  price: number
  source: null
  status: number
  userId: number
  userName: string
}

export interface AddOrUpdateShopItemDto {
  id?: number
  title: string
  description: string
  imgUrl: string
  price: number
  stock: number
  status: number
}
export interface BackendExchangeListSearchParams extends PageSearchParams {
  source: string
  status?: 0 | 1 | 2
  itemName?: string
}
