import type { Router } from 'vue-router'

import { saveScrollPosition } from './scrollStorage'
import { parseCode, parseIsCodeLogin, parseIsCutEmail } from '@/utils/wxUtil'
import { useUserStore } from '@/stores'

// 白名单
const WHITE_LIST: string[] = ['/aa']

export function registerRouterGuards(router: Router) {
  router.beforeEach(async (to, from) => {
    console.log('to', to)
    console.log('from', from)
    // 保存当前页面的滚动位置
    if (from.fullPath) {
      saveScrollPosition(from.fullPath, window.scrollY)
    }
    if (WHITE_LIST.includes(to.path)) {
      return true
    }

    const code = parseCode(to.fullPath)

    // code是否来自企业微信 1 不是 0 是 2 开发人员登录方式
    const isCodeLogin = parseIsCodeLogin()
    const cutEmail = parseIsCutEmail()
    console.log(code, isCodeLogin, cutEmail)
    const userStore = useUserStore()
    if (code) {
      console.log('code', code)
      await userStore.getUserInfoByCode(code, 0)
      // 去除url里面的code
      return {
        path: '/', // 重定向到首页 去除code 重定向到首页 没有code 不会进入到这里了
        replace: true,
      }
    } else {
      return true
    }
  })
}
