import service from '@/utils/request/index'
import type { AddOrUpdatePracticeDto, PracticeSearchParams, PracticeItemDto } from './types'
import type { BackendServicePageResult } from '@/utils/request/types'

// 关于实践相关接口

/**
 * 发布或者更新实践
 */
export const addOrUpdatePractice = (data: AddOrUpdatePracticeDto) => {
  return service.request<boolean>({
    url: '/api/cultureArticle/addOrUpdatePractice',
    method: 'POST',
    data,
  })
}

/**
 * 实践列表接口
 */
export const getPracticeList = (data: PracticeSearchParams) => {
  return service.request<BackendServicePageResult<PracticeItemDto>>({
    url: '/api/yaCulture/practiceList',
    method: 'POST',
    data,
  })
}
