/**
 * 通过某个条件，将一个数组，分隔成两个数组
 * @param arr
 * @param callback
 */
export function splitArray<T = unknown>(arr: T[], callback: (item: T) => boolean) {
  const arr1: T[] = []
  const arr2: T[] = []
  arr.forEach((v) => {
    if (callback(v)) {
      arr1.push(v)
    } else {
      arr2.push(v)
    }
  })
  return {
    false: arr2,
    true: arr1,
  }
}
