import { defineStore } from 'pinia'
import { getVideoOptions } from '@/api'
import type { VideoOptionDto } from '@/api/article/types'
/**
 * 关于专访的相关数据 --不分页
 */
export const useVideoStore = defineStore('video', () => {
  const videoList = ref<VideoOptionDto[]>([])

  let isLoading = false

  const fetchVideoList = async () => {
    if (isLoading) return
    if (videoList.value.length > 0) return
    isLoading = true
    try {
      const { data } = await getVideoOptions()
      videoList.value = data
      console.log(videoList.value, 'videoList')
    } catch (error) {
      console.error(error)
    } finally {
      isLoading = false
    }
  }
  fetchVideoList()

  return { videoList, fetchVideoList }
})
