/* 企业微信js配置 */
//注意：如果要在页面调用企业微信内部方法，请现在下面的jsApiList数组中添加方法
import { getWxSignature } from '@/api'
import wx from 'weixin-js-sdk'

export async function initWxConfig() {
  const url = location.href.split('#')[0]
  const response = await getWxSignature(url)
  const timestamp = response.data.timestamp //时间戳
  const nonceStr = response.data.nonceStr //随机字符串
  const signature = response.data.signature //签名
  const appId = response.data.appId //企业id
  wx.config({
    beta: true, // 必须这么写，否则wx.invoke调用形式的jsapi会有问题
    debug: false, // 开启调试模式,调用的所有api的返回值会在客户端alert出来，若要查看传入的参数，可以在pc端打开，参数信息会通过log打出，仅在pc端时才会打印。
    appId: appId, // 必填，企业微信的corpID
    timestamp: timestamp, // 必填，生成签名的时间戳
    nonceStr: nonceStr, // 必填，生成签名的随机串
    signature: signature, // 必填，签名，见附录1
    jsApiList: [
      // 所有要调用的 API 都要加到这个列表中
      'shareAppMessage',
      'selectEnterpriseContact'
    ]
    // success: function (result) {
    //   // 回调
    // }
  })
}
