import service from '@/utils/request/index'
import type {
  BackendShopItemDto,
  AddOrUpdateShopItemDto,
  BackendExchangeListSearchParams,
  BackendShopListSearchParams,
} from './types'
import type { BackendServicePageResult } from '@/utils/request/types'
// 后台管理 积分商城相关接口

/**
 * 商品配置列表
 */
export const getShopItemList = (params: BackendShopListSearchParams) => {
  return service.request<BackendServicePageResult<BackendShopItemDto>>({
    url: '/api/culture/shop/item/productList',
    method: 'POST',
    data: params,
  })
}

/**
 * 新增/编辑商品
 */
export const addOrUpdateShopItem = (data: AddOrUpdateShopItemDto) => {
  return service.request({
    url: '/api/culture/shop/item/addOrUpdate',
    method: 'POST',
    data,
  })
}

/*
 * 删除商品
 */
export const deleteShopItem = (id: number) => {
  return service.request({
    url: `/api/culture/shop/item/deleteProduct?id=${id}`,
    method: 'POST',
  })
}
/**
 * 后台商品领用列表
 */
export const getBackendExchangeList = (data: BackendExchangeListSearchParams) => {
  return service.request<BackendServicePageResult<BackendShopItemDto>>({
    url: '/api/culture/shop/order/background/productList',
    method: 'POST',
    data,
  })
}

/**
 * 发放 取消发放
 */
export const issueProduct = (data: { id: number; status: number; memo?: string }) => {
  return service.request({
    url: `/api/culture/shop/order/issueProduct`,
    method: 'POST',
    data,
  })
}

/**
 * 商品分发页导出数据
 */
export const exportShopItemList = (data: BackendShopListSearchParams) => {
  return service.request<BackendShopItemDto[]>({
    url: '/api/culture/shop/order/background/productExport',
    method: 'POST',
    data,
  })
}
