interface IConfig {
  /** 网络请求url */
  baseUrl: string
  /** 用户登录 type */
  loginType: number
  /** 微信登录跳转路径 */
  wxRedirect: string
}

export const app_config: { [key: string]: IConfig } = {
  // 正式环境
  production: {
    baseUrl: 'http://oa.yswg.com.cn:8082',
    loginType: 3,
    wxRedirect: 'oa3.yswg.com.cn',
  },

  // 测试环境
  test: {
    baseUrl: 'http://47.119.149.50:8082',
    loginType: 1,
    wxRedirect: 'oatest.yswg.com.cn:3457',
  },

  // 开发环境
  development: {
    // baseUrl: 'http://oa.yswg.com.cn:8082', // 正式环境
    baseUrl: '/api1', // 线上测试机
    // baseUrl: 'http://192.168.2.110:8082', // 线上测试机
    // baseUrl: 'http://192.168.2.85:8080', // 洋倍
    // baseUrl: 'http://192.168.2.12:8084', // 立鹏
    // baseUrl: 'http://192.168.2.55:8089', // 首拥
    loginType: 1,
    wxRedirect: 'oatest.yswg.com.cn:3457',
  },
}
