import CryptoJS from 'crypto-js'

/**
 * 使用 MD5 加密字符串
 * @param input - 要加密的字符串
 * @returns 加密后的 MD5 字符串
 */
export function md5Hash(input: string): string {
  return CryptoJS.MD5(input).toString()
}

/**
 * AES 加密方法
 * @param plaintext 要加密的明文
 * @param key 密钥 (16, 24 或 32 字节长度的字符串)
 * @returns 加密后的字符串
 */
export function aesEncrypt(plaintext: string, key: string): string {
  if (![16, 24, 32].includes(key.length)) {
    throw new Error('秘钥长度必须为 16, 24 或 32 字节。')
  }

  // 加密数据
  const encrypted = CryptoJS.AES.encrypt(plaintext, CryptoJS.enc.Utf8.parse(key), {
    mode: CryptoJS.mode.ECB,
    padding: CryptoJS.pad.Pkcs7,
  })

  return encrypted.toString()
}
