import { ArticleTypeEnum, ReleaseStatusTypeEnum, BooleanFlag, SendTypeEnum } from '@/constants'
import type { PageSearchParams } from '@/utils/request/types'

/**
 * 添加或更新实践DTO
 */
export interface AddOrUpdatePracticeDto {
  id?: number
  title: string
  content: string
  faceUrl: string
  imgUrl: string
  releaseStatus: ReleaseStatusTypeEnum
  mainTagId: number | string
  tagList: { tagId: number; sort: number }[]
  sendType: SendTypeEnum
  sendTime: string
  type?: ArticleTypeEnum
}

/**
 * 搜索文章的参数
 */
export interface PracticeSearchParams extends PageSearchParams {
  sortLogic: number
  tagIdList: number[]
  deptIdList: string[]
  title?: string
}

/**
 * 实践列表item
 */
export interface PracticeItemDto {
  collectionCount: number
  content: string
  createTime: number
  createUserId: number
  description: string
  faceUrl: string
  hasPraised: boolean
  id: number
  isRecommend: BooleanFlag
  praiseCount: number
  releaseStatus: ReleaseStatusTypeEnum
  replyCount: number
  showAvatar: string
  showName: string
  tagNameList: string[]
  title: string
  type: ArticleTypeEnum.PRACTICE
  viewCount: number
}
