import service from '@/utils/request/index'
import type { BooleanFlag } from '@/constants'
import type { OtherUserInfoDto, OtherUserPostDataSearchParams, OtherUserPostDataDto } from './types'
import type { BackendServicePageResult } from '@/utils/request/types'

// 其他用户页面数据

/**
 * 获取其他用户的用户信息
 */
export const getOtherUserData = (data: { userId: string; isReal: BooleanFlag }) => {
  return service.request<OtherUserInfoDto>({
    url: '/api/personalCenter/userData',
    method: 'POST',
    data,
  })
}

/**
 * 显示其他用户的发帖数据
 */
export const getOtherUserPostData = (data: OtherUserPostDataSearchParams) => {
  return service.request<BackendServicePageResult<OtherUserPostDataDto>>({
    url: '/api/personalCenter/getUserArticleData',
    method: 'POST',
    data,
  })
}
