import service from '@/utils/request/index'
import type { AddOrUpdateTagDto, BackendTagListItemDto, BackendTagSearchParams } from './types'
import type { BackendServicePageResult } from '@/utils/request/types'
// 后台管理标签相关接口

/**
 * 获取轮播图列表  不分页 数量不多
 */
export const getCarouselList = () => {
  return service.request<BackendServicePageResult<BackendTagListItemDto>>({
    url: '/api/cultureCarousel/listNoPage',
    method: 'POST',
    data: {},
  })
}

/**
 * 添加轮播图
 */
export const addCarousel = (data: AddOrUpdateCarouselDto) => {
  return service.request({
    url: '/api/cultureCarousel/addCarousel',
    method: 'POST',
    data,
  })
}

/**
 * 更新轮播图
 */
export const editCarousel = (data: AddOrUpdateCarouselDto) => {
  return service.request({
    url: '/api/cultureCarousel/editCarousel',
    method: 'POST',
    data,
  })
}

/**
 * 更改发布状态
 */
export const deleteCarousel = (id: number) => {
  return service.request<boolean>({
    url: `/api/cultureCarousel/updateRelease?id=${id}`,
    method: 'POST',
  })
}
