import type { Router } from 'vue-router'

import { saveScrollPosition } from './scrollStorage'
import { parseCode, parseIsCodeLogin, parseIsCutEmail } from '@/utils/wxUtil'
import { useUserStore } from '@/stores'

// 白名单
const WHITE_LIST: string[] = []

export function registerRouterGuard(router: Router) {
  router.beforeEach(async (to, from, next) => {
    // 保存当前页面的滚动位置
    if (from.fullPath) {
      saveScrollPosition(from.fullPath, window.scrollY)
    }
    if (WHITE_LIST.includes(to.path)) {
      next()
      return
    }

    const code = parseCode()

    // code是否来自企业微信 1 不是 0 是 2 开发人员登录方式
    const isCodeLogin = parseIsCodeLogin()
    const cutEmail = parseIsCutEmail()
    console.log(code, isCodeLogin, cutEmail)
    const userStore = useUserStore()

    if (code) {
      await userStore.getUserInfoByCode(code)
      return next()
    } else {
      return next()
    }
  })
}
