// 常规的接口
// import service from '@/utils/request/index'
// import type { FielItemDto } from './types'
/**
 * 获取常规的接口
 */
// export const uploadFile = (file: File, onProgress?: (progress: number) => void) => {
//   const formData = new FormData()
//   formData.append('file', file)
//   return service.request<FielItemDto>({
//     url: '/mobiles/file-upload/singleUpload',
//     method: 'POST',
//     data: formData,
//     onUploadProgress: (progressEvent) => {
//       const percentCompleted = Math.round((progressEvent.loaded * 100) / (progressEvent.total || 1))
//       onProgress?.(percentCompleted)
//     },
//   })
// }

/**
 * 暂时调用oa正式接口
 */
import axios from 'axios'
type UploadFileResponse = {
  data: {
    data: {
      createTime: string
      createUser: number
      fileBucket: string
      fileId: string
      fileName: string
      filePath: string
      fileSizeKb: number
      fileSuffix: string
      finalName: string
      realPath: string
      updateTime: string
      updateUser: string
    }[]
  }
}
export const uploadFile = (
  file: File,
  onProgress?: (progress: number) => void,
): Promise<UploadFileResponse> => {
  const formData = new FormData()
  formData.append('fileList', file)
  return axios.post('http://47.112.96.71:8082/mobiles/uploadFile', formData, {
    onUploadProgress: (progressEvent) => {
      const percentCompleted = Math.round((progressEvent.loaded * 100) / (progressEvent.total || 1))
      onProgress?.(percentCompleted)
    },
  })
}
