import service from '@/utils/request/index'
import type { AddOrUpdateCaseDto } from './types'
import type { BooleanFlag } from '@/constants'

// 其他用户页面数据

/**
 * 获取其他用户的用户信息
 */
export const getOtherUserData = (data: { userId: string; isReal: BooleanFlag }) => {
  return service.request<string>({
    url: '/api/personalCenter/userData',
    method: 'POST',
    data,
  })
}

/**
 * 显示其他用户的发帖数据
 */
export const getOtherUserPostData = (data: {
  userId: string
  isReal: BooleanFlag
  current: number
  size: number
}) => {
  return service.request({
    url: '/api/personalCenter/userData',
    method: 'POST',
    data,
  })
}
