import service from '@/utils/request/index'
import type {
  ChangeUsageStatusDto,
  AuditCaseDto,
  BackendCaseListItemDto,
  CaseListSearchParams,
  BackendEditCaseDto,
} from './types'
import type { BackendServicePageResult } from '@/utils/request/types'
// 后台管理案例库相关接口

/**
 * 案例库后台列表
 */
export const getCaseList = (data: CaseListSearchParams) => {
  return service.request<BackendServicePageResult<BackendCaseListItemDto>>({
    url: '/api/cultureCase/caseListByPage',
    method: 'POST',
    data,
  })
}

/**
 * 删除案例库
 */
export const deleteCase = (id: number) => {
  return service.request({
    url: `/api/cultureCase/deleteCase?id=${id}`,
    method: 'POST',
  })
}

/**
 * 审核接口
 */
export const auditCase = (data: AuditCaseDto) => {
  return service.request({
    url: '/api/cultureCase/auditCase',
    method: 'POST',
    data,
  })
}

/**
 * 修改使用状态
 */

export const changeUsageStatus = (data: ChangeUsageStatusDto) => {
  return service.request({
    url: '/api/cultureCase/userCase',
    method: 'POST',
    data,
  })
}

/**
 * 导入excel的接口
 */

export const importCaseExcel = (file: File, onProgress?: (progress: number) => void) => {
  const formData = new FormData()
  formData.append('file', file)

  return service.request<BackendCaseListItemDto[]>({
    url: '/api/cultureCase/import',
    method: 'POST',
    data: formData,
    onUploadProgress: (progressEvent) => {
      const progress = Math.round((progressEvent.loaded * 100) / (progressEvent.total || 1))
      if (onProgress) {
        onProgress(progress)
      }
    },
  })
}

/**
 * 后台编辑案例库
 */
export const backendEditCase = (data: BackendEditCaseDto) => {
  return service.request({
    url: '/api/cultureCase/addOrUpdateCase',
    method: 'POST',
    data,
  })
}
