import { UsageStatusEnum, AuditStatusEnum } from '@/constants'
import type { PageSearchParams } from '@/utils/request/types'

export interface CaseListSearchParams extends PageSearchParams {
  isAudit?: AuditStatusEnum
  isUse?: UsageStatusEnum
  title?: string
}

export interface BackendCaseListItemDto {
  caseType: string
  content: string
  createTime: number
  createUser: number
  cultureKeywordMain: string
  cultureKeywordSecond: string[]
  cultureRelation: number
  dataSources: number
  depIdList: string[]
  depNameList: string[]
  deptId: string
  deptName: string
  id: number
  integrity: number
  isAudit: number
  isDelete: number
  isDispose: number
  isUse: number
  mainScene: string
  minorScene: string
  number: string
  sceneKeywordMain: string
  sceneKeywordSecond: string[]
  sourceProject: string
  sourceTime: number
  sourceType: string
  sourceUser: number
  title: string
  yearKeywordMain: string
  yearKeywordSecond: string[]
  sourceUserName: string
  sourceUserWorkNo: string
}

export interface ChangeUsageStatusDto {
  id: number
  isUse: UsageStatusEnum
}

export interface AuditCaseDto {
  id: number
  isAudit: AuditStatusEnum
}
