import { fileURLToPath, URL } from 'node:url'
import { defineConfig } from 'vite'
import vue from '@vitejs/plugin-vue'
import vueJsx from '@vitejs/plugin-vue-jsx'
import vueDevTools from 'vite-plugin-vue-devtools'
import AutoImport from 'unplugin-auto-import/vite'
import Components from 'unplugin-vue-components/vite'
import { ElementPlusResolver } from 'unplugin-vue-components/resolvers'
import { createSvgIconsPlugin } from 'vite-plugin-svg-icons'
import { visualizer } from 'rollup-plugin-visualizer'
import UnoCSS from 'unocss/vite'
import pushUpdatePlugin from './src/plugins/pushUpdatePlugin'
import IconsResolver from 'unplugin-icons/resolver'
import Icons from 'unplugin-icons/vite'
import path from 'node:path'

// https://vite.dev/config/
export default defineConfig(({ mode }) => {
  return {
    resolve: {
      //设置别名
      alias: {
        '@': fileURLToPath(new URL('./src', import.meta.url)),
      },
    },
    plugins: [
      vue(),
      vueJsx(),
      vueDevTools(),
      AutoImport({
        imports: ['vue', 'vue-router'],
        resolvers: [ElementPlusResolver()],
        dts: true,
        eslintrc: {
          enabled: true, // 生成 eslint 配置
        },
      }),
      Components({
        resolvers: [
          // 自动注册图标组件
          IconsResolver({
            enabledCollections: ['ep'], // 自动引入的icon 前缀要写成 <i-ep-xx/>
          }),
          ElementPlusResolver(),
        ],
        include: [/\.vue$/, /\.vue\?vue/, /\.vue\.[tj]sx?\?vue/, /\.[tj]sx$/], // 支持tsx jsx vue文件 无script 和有script 编译后不一样 一个直接是sfc里面只有render 一个是 sfc 里面有render 和setup
        dts: true,
      }),
      Icons({
        autoInstall: true,
      }),
      UnoCSS(),
      createSvgIconsPlugin({
        // 指定需要缓存的图标文件夹(路径为存放所有svg图标的文件夹不单个svg图标)
        iconDirs: [path.resolve(process.cwd(), 'src/assets/svg')],
        // 指定symbolId格式
        symbolId: 'icon-[dir]-[name]',
      }),
      mode === 'development' && visualizer(), // 开发环境打包才需要
      pushUpdatePlugin(),
    ],
    server: {
      // 是否开启 https
      // https: false as const,
      port: 3000,
      // proxy: {
      //   '/api1': {
      //     target: 'http://192.168.2.168:8089', // 立鹏本地
      //     // target: 'http://192.168.2.55:8089', // 首拥本地
      //     changeOrigin: true,
      //     rewrite: (path) => {
      //       return path.replace(/^\/api1/, '')
      //     },
      //   },
      // },
    },
    build: {
      minify: false,
      rollupOptions: {
        output: {
          assetFileNames: 'assets/[ext]/[name]-[hash][extname]',
          chunkFileNames: 'assets/js/[name]-[hash].js',
          manualChunks: (id) => {
            if (id.includes('node_modules')) {
              // console.log(id)
              if (id.includes('element-plus')) {
                return 'element-plus'
              } else if (id.includes('vue')) {
                return 'vue'
              }

              return 'vendor'
            }
          },
        },
      },
    },
  }
})
