import service from '@/utils/request/index'
import type { AddOrUpdateArticleDto, ArticleItemDto, ArticleSearchParams } from './types'
import type { BackendServicePageResult } from '@/utils/request/types'

import { ArticleTypeEnum } from '@/constants'

/**
 * 发布文章
 */
export const addOrUpdateArticle = (data: AddOrUpdateArticleDto) => {
  return service.request<boolean>({
    url: '/api/cultureArticle/addOrUpdateArticle',
    method: 'POST',
    data,
  })
}

/**
 * 文章列表
 */
export const getArticleList = (data: ArticleSearchParams) => {
  return service.request<BackendServicePageResult<ArticleItemDto>>({
    url: '/api/cultureArticle/listByPage',
    method: 'POST',
    data,
  })
}

/**
 * 文章详情
 */
export const getArticleDetail = (articleId: number | string) => {
  return service.request<ArticleItemDto>({
    url: `/api/cultureArticle/getArticleDetail?articleId=${articleId}`,
    method: 'POST',
  })
}

/**
 * 收藏或者取消收藏
 */
export const addOrCancelCollect = (data: { articleId: number | string; type: ArticleTypeEnum }) => {
  return service.request<boolean>({
    url: `/api/cultureCollect/addOrCancelCollect`,
    method: 'POST',
    data,
  })
}
